﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Model;
using System.Windows.Forms;

namespace IndianHealthService.BMXNet.EHR.Model
{
    internal class CiaPatient : CiaObject, Patient,IDisposable
    {

        public static CiaPatient FindCurrent(CiaSession aSession)
        {
            CiaPatient answer = new CiaPatient();

            if (aSession.CssPatient.Handle == 0)
            {
                return null;
            }
            else
            {
                answer.Ien = aSession.CssPatient.Handle.ToString();
                answer.PatientName = aSession.CssPatient.Name;
                answer.Sex = aSession.CssPatient.Sex;
                answer.HealthRecordNumber = aSession.CssPatient.HRN;
                
                try
                {
                    answer.Dob = aSession.CssPatient.DOB;
                }
                catch
                {
                    answer.Dob = null;
                }
                try
                {
                    answer.AdmitDate = aSession.CssPatient.AdmitDate;
                }
                catch
                {
                    answer.AdmitDate = null;
                }
                answer.Age = aSession.CssPatient.Age;
                answer.Ssn = aSession.CssPatient.SSN;

                return answer;
            }
        }

          #region IDisposable Members

          public void Dispose()
          {
      
          }

          #endregion


          private String _patientName;

          public String PatientName
          {
              get { return _patientName; }
              set { _patientName = value; }
          }

          private DateTime? _admitDate;

          public DateTime? AdmitDate
          {
              get { return _admitDate; }
              set { _admitDate = value; }
          }


          private String _healthRecordNumber = "";

          public String HealthRecordNumber
          {
              get { return _healthRecordNumber; }
              set { _healthRecordNumber = value; }
          }

          private float _age;

          public float Age
          {
              get { return _age; }
              set { _age = value; }
          }
          private DateTime? _dob;

          public DateTime? Dob
          {
              get { return _dob; }
              set { _dob = value; }
          }
          private String _primaryProvider;

          public String PrimaryProvider
          {
              get { return _primaryProvider; }
              set { _primaryProvider = value; }
          }
          private String _sex;

          public String Sex
          {
              get { return _sex; }
              set { _sex = value; }
          }
          private String _ssn;

          public String Ssn
          {
              get { return _ssn; }
              set { _ssn = value; }
          }

          
          public String DebugString()
          {
              StringBuilder info = new StringBuilder();

              info.Append(this.PatientName);
              info.Append(", ");
              info.Append(this.Dob.HasValue ? this.Dob.Value.ToShortDateString() : "");

              return info.ToString();
          }


    }
}

/*           Notes

              this.CssPatient.AdmitDate
              this.CssPatient.Age
              this.CssPatient.DOB
              this.CssPatient.Detail
              this.CssPatient.DOD
              this.CssPatient.HRN
              this.CssPatient.ICN
              this.CssPatient.Location
              this.CssPatient.LocationName
              this.CssPatient.PrimaryProvider
              this.CssPatient.PrimaryTeam
              this.CssPatient.RoomBed
              this.CssPatient.Sex
              this.CssPatient.SSN
*/
